"use client"
import LoadingCircle from "@/components/icons/loading.circle";
import { cn } from "@/lib/utils";
import { ComponentWithClassNameAndChildren } from "@/types/utils";
import { Cell } from "@tanstack/react-table";
import { CircleCheck, CircleMinus, CircleX, TriangleAlert } from "lucide-react";
import { TransformedAgency } from "@/types/transformers";

export function AgenciesCellStatus({ cell }: { cell: Cell<TransformedAgency, unknown> }) {
  const { dates } = cell.getValue<TransformedAgency>()

  return (
    <INTERNAL__Wrapper>
      {INTERNAL__getStatusFromPreviewAndLiveStatus(dates.uploadedToPreview, dates.uploadedToLive)}
    </INTERNAL__Wrapper>
  )
}

function INTERNAL__getStatusFromPreviewAndLiveStatus(uploadedToPreview: Date | undefined, uploadedToLive: Date | undefined) {
  const inPreview = !!uploadedToPreview
  const inLive = !!uploadedToLive
  const previewFilesAreAheadOfLive = (uploadedToPreview && uploadedToLive && uploadedToPreview > uploadedToLive)

  if (
    inPreview && inLive && !previewFilesAreAheadOfLive
  ) {
    return getStatusIcon("positive")
  }

  if (!inPreview && inLive ||
    inPreview && !inLive ||
    previewFilesAreAheadOfLive
  ) {
    return getStatusIcon("indeterminate")
  }

  return getStatusIcon("negative")
}

export function getStatusIcon(status: "loading" | "negative" | "positive" | "error" | "indeterminate") {
  if (status === "loading") {
    return (
      <LoadingCircle />
    )
  }

  if (status === "error") {
    return (
      <TriangleAlert className="size-4 text-destructive" />
    )
  }

  if (status === "indeterminate") {
    return (
      <CircleMinus className="size-4 text-yellow-700 dark:text-yellow-600 bg-background" />
    )
  }

  if (status === "negative") {
    return (
      <CircleX className="size-4 text-destructive" />
    )
  }

  if (status === "positive") {
    return (
      <CircleCheck className="size-4 text-primary" />
    )
  }

  return null
}

function INTERNAL__Wrapper({ className, children }: ComponentWithClassNameAndChildren) {
  return (
    <div className={cn("flex flex-row gap-2 items-center", className)}>
      {children}
    </div>
  )
}
